using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using MSBOS = gov.va.med.vbecs.Common.VbecsTables.Msbos;
using MSBOSCOMPONENTCLASS = gov.va.med.vbecs.Common.VbecsTables.MsbosComponentClass;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgMaintainMsbos
	/// </summary>
	public class DlgMaintainMsbos : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// _msbos
		/// </summary>
		private BOL.Msbos _msbos;

		/// <summary>
		/// _msbosComponentClass
		/// </summary>
		private BOL.MsbosComponentClass _msbosComponentClass;

		/// <summary>
		/// _msbosComponents
		/// </summary>
		private DataSet _msbosComponents;

		/// <summary>
		/// _selectedMSBOS
		/// </summary>
		private DataRow _selectedMSBOS;

		/// <summary>
		/// _selectedComponentClass
		/// </summary>
		private DataRow _selectedComponentClass;

		/// <summary>
		/// _orderableComponentClasses
		/// </summary>
		private DataTable _orderableComponentClasses;

		/// <summary>
		/// _isLoading
		/// </summary>
		private bool _isLoading = true; 

		/// <summary>
		/// _currentSurgery
		/// </summary>
		private string _currentSurgery = String.Empty;

		private bool _firsttimePaint = true;

		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpExisitingMSBOS;
		private System.Windows.Forms.TreeView tvExistingMSBOS;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnNewSurgery;
		private System.Windows.Forms.GroupBox grpMSBOS;
		private System.Windows.Forms.GroupBox grpComponent;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updUnitsAllowed;
		private System.Windows.Forms.Label lblUnitsAllowed;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComponentClass;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox grpSurgery;
		private System.Windows.Forms.CheckBox cbActive;
		private System.Windows.Forms.TextBox txtSurgeryName;
		private System.Windows.Forms.Label lblSurgeryName;
		private System.Windows.Forms.CheckBox cbShowInactive;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSave;
		private System.Windows.Forms.CheckBox cbActiveComponent;
		private System.Windows.Forms.GroupBox grpRecommendation;
		private System.Windows.Forms.RadioButton rdoTAS;
		private System.Windows.Forms.RadioButton rdoNoBloodRequired;
		private System.Windows.Forms.RadioButton rdoComponentClass;
		private System.ComponentModel.IContainer components = null;
		
		#endregion

		#region Constructors 


		/// <summary>
		/// DlgMaintainMsbos
		/// </summary>
		public DlgMaintainMsbos()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC032MaintainMsbos;

			// This call is required by the Windows Form Designer.
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.vbecsLogo1.Title = "Maintain MSBOS";
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//this.btnEditSurgery.Enabled = false;
			this.SetBtnSaveCaption("&Update");
			//
			this.tvExistingMSBOS.PathSeparator = "\t";
			//
			//This will load the initial bit of data
			this.SetupFormVariables();
			
			//Create a guid array
			foreach (System.Data.DataRow drMSBOS in this._msbosComponents.Tables[0].Rows)
			{
				this.LockController.RecordGuids.Add((Guid)drMSBOS[MSBOS.MsbosGuid]);
			}
			//Try locking. Abort will notify the instatiator that locking failed
			if (!this.SetLocks())
			{
				this.DialogResult = DialogResult.Abort;
				this.Close();
				return;
			}		

			this.PopulateOrderableComponents();
			//
			this.LoadMSBOSTreeView();
			//
			if (this.tvExistingMSBOS.Nodes.Count == 0)
			{
				//No active MSBOS entries, so show all inactive instead...
				this.cbShowInactive.Checked = true;
			}
			//
			this.SetSurgeryData(true);
			this.SetComponentData(true);
			//this.grpSurgery.Enabled = false;
			//this.grpTypeAndScreen.Enabled = false;
			this.grpRecommendation.Enabled = false;
			this.grpComponent.Enabled = false;
			//
			this._msbos.Clear();
			this._msbosComponentClass.Clear();
			//
			this.AttachCCEvents();
			this.AttachMSBOSEvents();
			//
			this.btnSave.EnabledButton = false;
			this.IsDirty=false;
			//
			this.SetToolTips();
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgMaintainMsbos));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.btnNewSurgery = new System.Windows.Forms.Button();
			this.tvExistingMSBOS = new System.Windows.Forms.TreeView();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.updUnitsAllowed = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.cmbComponentClass = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.cbActive = new System.Windows.Forms.CheckBox();
			this.txtSurgeryName = new System.Windows.Forms.TextBox();
			this.cbActiveComponent = new System.Windows.Forms.CheckBox();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpExisitingMSBOS = new System.Windows.Forms.GroupBox();
			this.cbShowInactive = new System.Windows.Forms.CheckBox();
			this.grpMSBOS = new System.Windows.Forms.GroupBox();
			this.grpSurgery = new System.Windows.Forms.GroupBox();
			this.lblSurgeryName = new System.Windows.Forms.Label();
			this.btnSave = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpRecommendation = new System.Windows.Forms.GroupBox();
			this.rdoComponentClass = new System.Windows.Forms.RadioButton();
			this.rdoNoBloodRequired = new System.Windows.Forms.RadioButton();
			this.rdoTAS = new System.Windows.Forms.RadioButton();
			this.grpComponent = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.lblUnitsAllowed = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.updUnitsAllowed)).BeginInit();
			this.grpImage.SuspendLayout();
			this.grpExisitingMSBOS.SuspendLayout();
			this.grpMSBOS.SuspendLayout();
			this.grpSurgery.SuspendLayout();
			this.grpRecommendation.SuspendLayout();
			this.grpComponent.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(704, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Maintain MSBOS";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 441);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(540, 428);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(620, 428);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// btnNewSurgery
			// 
			this.btnNewSurgery.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnNewSurgery.Location = new System.Drawing.Point(264, 356);
			this.btnNewSurgery.Name = "btnNewSurgery";
			this.btnNewSurgery.Size = new System.Drawing.Size(84, 23);
			this.btnNewSurgery.TabIndex = 2;
			this.btnNewSurgery.Text = "Ne&w Surgery";
			this.btnNewSurgery.Click += new System.EventHandler(this.btnNewSurgery_Click);
			// 
			// tvExistingMSBOS
			// 
			this.tvExistingMSBOS.AccessibleDescription = "Maximum Surgical Blood Order Schedule";
			this.tvExistingMSBOS.AccessibleName = "Maximum Surgical Blood Order Schedule";
			this.tvExistingMSBOS.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tvExistingMSBOS.FullRowSelect = true;
			this.tvExistingMSBOS.HideSelection = false;
			this.tvExistingMSBOS.ImageList = this.imageList1;
			this.tvExistingMSBOS.Location = new System.Drawing.Point(8, 20);
			this.tvExistingMSBOS.Name = "tvExistingMSBOS";
			this.tvExistingMSBOS.Nodes.AddRange(new System.Windows.Forms.TreeNode[] {
																						new System.Windows.Forms.TreeNode("Surgery Name 1", 0, 0, new System.Windows.Forms.TreeNode[] {
																																														  new System.Windows.Forms.TreeNode("Component Class (Units Allowed: 5)", 1, 1),
																																														  new System.Windows.Forms.TreeNode("Component Class (Units Allowed: 2)", 1, 1)}),
																						new System.Windows.Forms.TreeNode("Surgery Name 2", 0, 0),
																						new System.Windows.Forms.TreeNode("Surgery Name 3", 0, 0)});
			this.tvExistingMSBOS.Size = new System.Drawing.Size(340, 332);
			this.tvExistingMSBOS.TabIndex = 0;
			this.tvExistingMSBOS.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvExistingMSBOS_AfterSelect);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// updUnitsAllowed
			// 
			this.updUnitsAllowed.AccessibleDescription = "Number of Units Recommended";
			this.updUnitsAllowed.AccessibleName = "Number of Units Recommended";
			this.updUnitsAllowed.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updUnitsAllowed.Location = new System.Drawing.Point(184, 68);
			this.updUnitsAllowed.Maximum = new System.Decimal(new int[] {
																			99,
																			0,
																			0,
																			0});
			this.updUnitsAllowed.Minimum = new System.Decimal(new int[] {
																			1,
																			0,
																			0,
																			0});
			this.updUnitsAllowed.Name = "updUnitsAllowed";
			this.updUnitsAllowed.Size = new System.Drawing.Size(48, 20);
			this.updUnitsAllowed.TabIndex = 3;
			this.updUnitsAllowed.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updUnitsAllowed.Value = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.updUnitsAllowed.TextChanged += new System.EventHandler(this.updUnitsAllowed_ValueChanged);
			this.updUnitsAllowed.Leave += new System.EventHandler(this.updUnitsAllowed_Leave);
			this.updUnitsAllowed.ValueChanged += new System.EventHandler(this.updUnitsAllowed_ValueChanged);
			// 
			// cmbComponentClass
			// 
			this.cmbComponentClass.AccessibleDescription = "Crossmatch Class Name";
			this.cmbComponentClass.AccessibleName = "Crossmatch Class Name";
			this.cmbComponentClass.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComponentClass.Interval = 500;
			this.cmbComponentClass.Location = new System.Drawing.Point(8, 36);
			this.cmbComponentClass.MaxLength = 35;
			this.cmbComponentClass.Name = "cmbComponentClass";
			this.cmbComponentClass.Size = new System.Drawing.Size(224, 22);
			this.cmbComponentClass.TabIndex = 1;
			this.cmbComponentClass.SelectedIndexChanged += new System.EventHandler(this.cmbComponentClass_SelectedIndexChanged);
			// 
			// cbActive
			// 
			this.cbActive.AccessibleDescription = "Active M S B O S Entry";
			this.cbActive.AccessibleName = "Active M S B O S Entry";
			this.cbActive.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbActive.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbActive.Enabled = false;
			this.cbActive.Location = new System.Drawing.Point(8, 60);
			this.cbActive.Name = "cbActive";
			this.cbActive.Size = new System.Drawing.Size(232, 20);
			this.cbActive.TabIndex = 2;
			this.cbActive.Text = "Active &MSBOS Entry?";
			this.cbActive.CheckedChanged += new System.EventHandler(this.cbActive_CheckedChanged);
			// 
			// txtSurgeryName
			// 
			this.txtSurgeryName.AccessibleDescription = "Surgery Name";
			this.txtSurgeryName.AccessibleName = "Surgery Name";
			this.txtSurgeryName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSurgeryName.Location = new System.Drawing.Point(8, 36);
			this.txtSurgeryName.MaxLength = 50;
			this.txtSurgeryName.Name = "txtSurgeryName";
			this.txtSurgeryName.ReadOnly = true;
			this.txtSurgeryName.Size = new System.Drawing.Size(232, 20);
			this.txtSurgeryName.TabIndex = 1;
			this.txtSurgeryName.Text = "";
			this.txtSurgeryName.TextChanged += new System.EventHandler(this.txtSurgeryName_TextChanged);
			// 
			// cbActiveComponent
			// 
			this.cbActiveComponent.AccessibleDescription = "Active Component Recommendation";
			this.cbActiveComponent.AccessibleName = "Active Component Recommendation";
			this.cbActiveComponent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbActiveComponent.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbActiveComponent.Location = new System.Drawing.Point(8, 92);
			this.cbActiveComponent.Name = "cbActiveComponent";
			this.cbActiveComponent.Size = new System.Drawing.Size(224, 20);
			this.cbActiveComponent.TabIndex = 4;
			this.cbActiveComponent.Text = "&Active Component Recommendation?";
			this.cbActiveComponent.CheckedChanged += new System.EventHandler(this.cbActiveComponent_CheckedChanged);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 384);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpExisitingMSBOS
			// 
			this.grpExisitingMSBOS.AccessibleDescription = "Maximum Surgical Blood Order Schedule";
			this.grpExisitingMSBOS.AccessibleName = "Maximum Surgical Blood Order Schedule";
			this.grpExisitingMSBOS.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpExisitingMSBOS.Controls.Add(this.cbShowInactive);
			this.grpExisitingMSBOS.Controls.Add(this.tvExistingMSBOS);
			this.grpExisitingMSBOS.Controls.Add(this.btnNewSurgery);
			this.grpExisitingMSBOS.Location = new System.Drawing.Point(60, 36);
			this.grpExisitingMSBOS.Name = "grpExisitingMSBOS";
			this.grpExisitingMSBOS.Size = new System.Drawing.Size(356, 384);
			this.grpExisitingMSBOS.TabIndex = 0;
			this.grpExisitingMSBOS.TabStop = false;
			this.grpExisitingMSBOS.Text = "Maximum Surgical Blood Order Schedule";
			// 
			// cbShowInactive
			// 
			this.cbShowInactive.AccessibleDescription = "Show Inactive M S B O S entries";
			this.cbShowInactive.AccessibleName = "Show Inactive M S B O S entries";
			this.cbShowInactive.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbShowInactive.Location = new System.Drawing.Point(8, 356);
			this.cbShowInactive.Name = "cbShowInactive";
			this.cbShowInactive.Size = new System.Drawing.Size(256, 16);
			this.cbShowInactive.TabIndex = 1;
			this.cbShowInactive.Text = "&Show Inactive MSBOS entries";
			this.cbShowInactive.CheckedChanged += new System.EventHandler(this.cbShowInactive_CheckedChanged);
			// 
			// grpMSBOS
			// 
			this.grpMSBOS.AccessibleDescription = "Selected M S B O S Entry";
			this.grpMSBOS.AccessibleName = "Selected M S B O S Entry";
			this.grpMSBOS.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpMSBOS.Controls.Add(this.grpSurgery);
			this.grpMSBOS.Controls.Add(this.btnSave);
			this.grpMSBOS.Controls.Add(this.grpRecommendation);
			this.grpMSBOS.Location = new System.Drawing.Point(420, 36);
			this.grpMSBOS.Name = "grpMSBOS";
			this.grpMSBOS.Size = new System.Drawing.Size(280, 384);
			this.grpMSBOS.TabIndex = 1;
			this.grpMSBOS.TabStop = false;
			this.grpMSBOS.Text = "Selected MSBOS Entry";
			// 
			// grpSurgery
			// 
			this.grpSurgery.AccessibleDescription = "M S B O S Surgery";
			this.grpSurgery.AccessibleName = "M S B O S Surgery";
			this.grpSurgery.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSurgery.Controls.Add(this.cbActive);
			this.grpSurgery.Controls.Add(this.txtSurgeryName);
			this.grpSurgery.Controls.Add(this.lblSurgeryName);
			this.grpSurgery.Location = new System.Drawing.Point(8, 16);
			this.grpSurgery.Name = "grpSurgery";
			this.grpSurgery.Size = new System.Drawing.Size(264, 88);
			this.grpSurgery.TabIndex = 0;
			this.grpSurgery.TabStop = false;
			this.grpSurgery.Text = "MSBOS Surgery";
			// 
			// lblSurgeryName
			// 
			this.lblSurgeryName.Location = new System.Drawing.Point(8, 16);
			this.lblSurgeryName.Name = "lblSurgeryName";
			this.lblSurgeryName.Size = new System.Drawing.Size(84, 20);
			this.lblSurgeryName.TabIndex = 0;
			this.lblSurgeryName.Text = "Surgery Name*";
			this.lblSurgeryName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSave
			// 
			this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSave.EnabledButton = false;
			this.btnSave.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSave.Image = ((System.Drawing.Image)(resources.GetObject("btnSave.Image")));
			this.btnSave.Location = new System.Drawing.Point(196, 312);
			this.btnSave.Name = "btnSave";
			this.btnSave.Size = new System.Drawing.Size(75, 23);
			this.btnSave.TabIndex = 2;
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			this.btnSave.MouseHover += new System.EventHandler(this.btnSave_MouseHover);
			// 
			// grpRecommendation
			// 
			this.grpRecommendation.AccessibleDescription = "M S B O S Component Recomendation";
			this.grpRecommendation.AccessibleName = "M S B O S Component Recomendation";
			this.grpRecommendation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRecommendation.Controls.Add(this.rdoComponentClass);
			this.grpRecommendation.Controls.Add(this.rdoNoBloodRequired);
			this.grpRecommendation.Controls.Add(this.rdoTAS);
			this.grpRecommendation.Controls.Add(this.grpComponent);
			this.grpRecommendation.Location = new System.Drawing.Point(8, 112);
			this.grpRecommendation.Name = "grpRecommendation";
			this.grpRecommendation.Size = new System.Drawing.Size(264, 196);
			this.grpRecommendation.TabIndex = 1;
			this.grpRecommendation.TabStop = false;
			this.grpRecommendation.Text = "MSBOS Component Recommendation*";
			// 
			// rdoComponentClass
			// 
			this.rdoComponentClass.AccessibleDescription = "Blood Component Class";
			this.rdoComponentClass.AccessibleName = "Blood Component Class";
			this.rdoComponentClass.Location = new System.Drawing.Point(12, 68);
			this.rdoComponentClass.Name = "rdoComponentClass";
			this.rdoComponentClass.Size = new System.Drawing.Size(152, 16);
			this.rdoComponentClass.TabIndex = 2;
			this.rdoComponentClass.Text = "&Blood Component Class";
			this.rdoComponentClass.CheckedChanged += new System.EventHandler(this.rdoComponentClass_CheckedChanged);
			// 
			// rdoNoBloodRequired
			// 
			this.rdoNoBloodRequired.AccessibleDescription = "No Blood Order Recommended";
			this.rdoNoBloodRequired.AccessibleName = "No Blood Order Recommended";
			this.rdoNoBloodRequired.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoNoBloodRequired.Location = new System.Drawing.Point(12, 44);
			this.rdoNoBloodRequired.Name = "rdoNoBloodRequired";
			this.rdoNoBloodRequired.Size = new System.Drawing.Size(236, 20);
			this.rdoNoBloodRequired.TabIndex = 1;
			this.rdoNoBloodRequired.Text = "&No Blood Order Recommended";
			this.rdoNoBloodRequired.CheckedChanged += new System.EventHandler(this.rdoNoBloodRequired_CheckedChanged);
			// 
			// rdoTAS
			// 
			this.rdoTAS.AccessibleDescription = "Type and Screen";
			this.rdoTAS.AccessibleName = "Type and Screen";
			this.rdoTAS.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoTAS.Location = new System.Drawing.Point(12, 20);
			this.rdoTAS.Name = "rdoTAS";
			this.rdoTAS.Size = new System.Drawing.Size(236, 20);
			this.rdoTAS.TabIndex = 0;
			this.rdoTAS.TabStop = true;
			this.rdoTAS.Text = "&Type && Screen";
			this.rdoTAS.CheckedChanged += new System.EventHandler(this.cbTypeAndScreen_CheckedChanged);
			// 
			// grpComponent
			// 
			this.grpComponent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComponent.Controls.Add(this.cbActiveComponent);
			this.grpComponent.Controls.Add(this.cmbComponentClass);
			this.grpComponent.Controls.Add(this.label1);
			this.grpComponent.Controls.Add(this.updUnitsAllowed);
			this.grpComponent.Controls.Add(this.lblUnitsAllowed);
			this.grpComponent.Location = new System.Drawing.Point(8, 68);
			this.grpComponent.Name = "grpComponent";
			this.grpComponent.Size = new System.Drawing.Size(248, 120);
			this.grpComponent.TabIndex = 3;
			this.grpComponent.TabStop = false;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 20);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(144, 20);
			this.label1.TabIndex = 0;
			this.label1.Text = "Component Class Name*";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblUnitsAllowed
			// 
			this.lblUnitsAllowed.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblUnitsAllowed.Location = new System.Drawing.Point(8, 68);
			this.lblUnitsAllowed.Name = "lblUnitsAllowed";
			this.lblUnitsAllowed.Size = new System.Drawing.Size(196, 20);
			this.lblUnitsAllowed.TabIndex = 2;
			this.lblUnitsAllowed.Text = "Number of Units Recommended*";
			this.lblUnitsAllowed.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgMaintainMsbos
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(704, 457);
			this.Controls.Add(this.grpMSBOS);
			this.Controls.Add(this.grpExisitingMSBOS);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "MSBOS.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(568, 484);
			this.Name = "DlgMaintainMsbos";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Maintain MSBOS";
			this.Load += new System.EventHandler(this.DlgMaintainMsbos_Load);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgMaintainMsbos_KeyDownSpeakMessage);
			this.Paint += new System.Windows.Forms.PaintEventHandler(this.DlgMaintainMsbos_Paint);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpExisitingMSBOS, 0);
			this.Controls.SetChildIndex(this.grpMSBOS, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			((System.ComponentModel.ISupportInitialize)(this.updUnitsAllowed)).EndInit();
			this.grpImage.ResumeLayout(false);
			this.grpExisitingMSBOS.ResumeLayout(false);
			this.grpMSBOS.ResumeLayout(false);
			this.grpSurgery.ResumeLayout(false);
			this.grpRecommendation.ResumeLayout(false);
			this.grpComponent.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		
		#region Events

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/30/2003</CreationDate>
		///
		/// <summary>
		/// Event that will enable the OK button at the bottom of the form if data changes
		/// </summary>
		private void MSBOSDataSetChanged(object sender, System.Data.DataRowChangeEventArgs e)
		{
			this.btnOK.EnabledButton = true;
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/30/2003</CreationDate>
		///
		/// <summary>
		/// Dis/Enables the Save button if the objects are in/valid
		/// </summary>
		
		private void OnObjectsValidStateChanges(object sender, EventArgs e )
		{
			if (!_isLoading)
			{
				if (this._msbos != null)
				{
					if (!this._msbos.IsDirty)
					{
						if ((this._msbosComponentClass ==null) || (!this._msbosComponentClass.IsDirty))
						{
							btnSave.EnabledButton = false;
							return;
						}

					}
					//
					if (!this._msbos.IsValid)
					{
						btnSave.EnabledButton = false;
						return;
					}
					//
					//We have to do this check here, since IsDuplicateSurgery can't be performed in BOL
					if (this.errError.GetError(this.txtSurgeryName).Length != 0)
					{
						btnSave.EnabledButton = false;
						return;
					}
					//
					string filterStr = MSBOS.MsbosGuid + " = '" + _msbos.MsbosGuid.ToString() + "'";
					int activeClasses = this._msbosComponents.Tables[1].Select(filterStr).Length;
					//
					if ((activeClasses==0) || ((this.tvExistingMSBOS.SelectedNode!=null) && (this.GetSelectedLevel(this.tvExistingMSBOS.SelectedNode)==1)))
					{
						if ((!this._msbos.IsTypeAndScreen) && (!this.rdoNoBloodRequired.Checked))
						{
							if (!this._msbosComponentClass.IsValid)
							{
								btnSave.EnabledButton = false;
								return;
							}
						}
					}
				}
				//
				btnSave.EnabledButton = true;
				this.SetDirtyFlag(sender,e);
			}
		}


		#endregion

		#region Methods

		private void SetToolTips()
		{
			this.SetThisToolTip(this.tvExistingMSBOS,Common.StrRes.Tooltips.UC032.ListMSBOSDetails());
			this.SetThisToolTip(this.cbShowInactive,Common.StrRes.Tooltips.Common.ShowInactive("MSBOS entries"));
			this.SetThisToolTip(this.btnNewSurgery, Common.StrRes.Tooltips.UC032.AddSurgeryItem());
			//
			this.SetThisToolTip(this.txtSurgeryName,Common.StrRes.Tooltips.UC032.ExistingSurgeryName());
			this.SetThisToolTip(this.cbActive,Common.StrRes.Tooltips.UC032.ActivateSurgery());
			//
			this.SetThisToolTip(this.rdoComponentClass, Common.StrRes.Tooltips.UC032.ComponentClass());
			this.SetThisToolTip(this.rdoNoBloodRequired, Common.StrRes.Tooltips.UC032.NoBloodRecommended());
			this.SetThisToolTip(this.rdoTAS, Common.StrRes.Tooltips.UC032.TypeAndScreen());
			this.SetThisToolTip(this.cmbComponentClass, Common.StrRes.Tooltips.UC032.SelectComponentClass());
			this.SetThisToolTip(this.updUnitsAllowed, Common.StrRes.Tooltips.UC032.SelectUnits());
			this.SetThisToolTip(this.cbActiveComponent, Common.StrRes.Tooltips.UC032.ActivateComponent());
			//
			this.SetThisToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel());
		}

		/// <summary>
		/// SetSurgeryData
		/// </summary>
		/// <param name="isReset"></param>
		private void SetSurgeryData(bool isReset)
		{
			this._isLoading = true;
			//
			if (isReset)
			{
				this._currentSurgery = "";
				this.txtSurgeryName.Text = string.Empty;
				this.cbActive.Checked = false;
				//this.cbTypeAndScreen.Checked = false;
				this.rdoTAS.Checked = false;
				this.rdoNoBloodRequired.Checked = false;
				this.rdoComponentClass.Checked = false;
			}
			else
			{
				this.txtSurgeryName.Text = this._msbos.SurgeryName;
				this.cbActive.Checked = (this._msbos.RecordStatusCode == Common.RecordStatusCode.Active);
				//this.cbTypeAndScreen.Checked = this._msbos.IsTypeAndScreen;
				this.rdoTAS.Checked = this._msbos.IsTypeAndScreen;
				this.rdoNoBloodRequired.Checked = this._msbos.IsNoBloodRequired;
			}
			//
			this._isLoading = false;
		}

		/// <summary>
		/// SetComponentData
		/// </summary>
		/// <param name="isReset"></param>
		private void SetComponentData(bool isReset)
		{
			this._isLoading = true;
			//
			try
			{
				if (isReset)
				{
					this.cmbComponentClass.SelectedIndex = -1;
					this.updUnitsAllowed.Value = 1;
					this.cbActiveComponent.Checked = false;
				}
				else
				{
					this.cmbComponentClass.SelectedIndex = cmbComponentClass.Items.IndexOf(this._msbosComponentClass.ComponentClassName);
					this.updUnitsAllowed.Value = this._msbosComponentClass.MaximumSetupUnitQuantity;
					this.cbActiveComponent.Checked = (this._msbosComponentClass.RecordStatusCode == Common.RecordStatusCode.Active);
				}
			}
			catch
			{
				this.cmbComponentClass.SelectedIndex = -1;
				this.updUnitsAllowed.Value = 1;
				this.cbActiveComponent.Checked = false;
			}
			finally
			{
				this._isLoading = false;
			}
		}


		/// <summary>
		/// AttachMSBOSEvents
		/// </summary>
		private void AttachMSBOSEvents()
		{
			this._msbos.SetInitialBrokenRules(this.Name,"Msbos");
			this._msbos.Invalid += new System.EventHandler(OnObjectsValidStateChanges);
			this._msbos.IsDirtyChanged += new System.EventHandler(OnObjectsValidStateChanges);
			//setting the event to fire the setdirtyflag function
			//this._msbos.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
			this._msbos.Valid += new System.EventHandler(OnObjectsValidStateChanges);
		}


		/// <summary>
		/// AttachCCEvents
		/// </summary>
		private void AttachCCEvents()
		{
			this._msbosComponentClass.SetInitialBrokenRules(this.Name,"MsbosComponentClass");
			this._msbosComponentClass.Invalid += new System.EventHandler(OnObjectsValidStateChanges);
			this._msbosComponentClass.IsDirtyChanged += new System.EventHandler(OnObjectsValidStateChanges);
			//setting the event to fire the setdirtyflag function
			//this._msbosComponentClass.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
			this._msbosComponentClass.Valid += new System.EventHandler(OnObjectsValidStateChanges);
		}


		/// <summary>
		/// IsDuplicateSurgery
		/// </summary>
		/// <returns></returns>
		private bool IsDuplicateSurgery()
		{
			string _val1, _val2;
			//bool _bool1, _bool2;

			if (this._currentSurgery.ToUpper() != this.txtSurgeryName.Text.ToUpper())
			{
				foreach(DataRow dr in _msbosComponents.Tables[0].Rows)
				{
					//foreach(TreeNode node in this.tvExistingMSBOS.Nodes)
					//{
					//DataRow dr = (DataRow)node.Tag;

					_val1 = dr[MSBOS.SurgeryName.ToString()].ToString().ToUpper();
					_val2 = this.txtSurgeryName.Text.ToUpper();

					//_bool1 = (bool)dr[MSBOS.TypeAndScreenIndicator.ToString()];
					//_bool2 = this.cbTypeAndScreen.Checked;

					if (_val1 == _val2)// && (_bool1 == _bool2))
					{
						this.errError.SetVbecsError(this.txtSurgeryName, "Duplicate surgery name not allowed"); // **** 508 Compliance ***
						return true;
					}
				}
			}
			return false;			
		}



		/// <summary>
		/// CreateComponentClass
		/// </summary>
		private void CreateComponentClass()
		{
			this._selectedComponentClass = (DataRow)this.tvExistingMSBOS.SelectedNode.Tag;
			this._msbosComponentClass = new BOL.MsbosComponentClass(this._selectedComponentClass);
			this.AttachCCEvents();
		}
        

		/// <summary>
		/// HasAuthority
		/// </summary>
		/// <returns></returns>
		private bool HasAuthority()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.EditConsultativeReports );
		}


		/// <summary>
		/// LoadMSBOSTreeView
		/// </summary>
		private void LoadMSBOSTreeView()
		{
			this.tvExistingMSBOS.Nodes.Clear();
			//
			DataTable dtComponents = _msbosComponents.Tables[1];
			//
			foreach(DataRow drMSBOS in _msbosComponents.Tables[0].Rows)
			{
				this._selectedMSBOS = drMSBOS;
				//
				BOL.Msbos _tmpMSBOS = new BOL.Msbos(this._selectedMSBOS);
				//
				//Don't display if inactive and the Show Inactive checkbox is unchecked
				if ((_tmpMSBOS.RecordStatusCode == Common.RecordStatusCode.Inactive) && (!this.cbShowInactive.Checked))
				{
					continue;
				}
				//
				string filterStr = MSBOS.MsbosGuid + " = '" + _tmpMSBOS.MsbosGuid.ToString() + "'";
				_tmpMSBOS.BloodComponentClasses = dtComponents.Select(filterStr);
				//
				AddMSBOSNode(_tmpMSBOS);
				//
				//Only display components if not type and screen
				//or No Blood required
				if ((!_tmpMSBOS.IsTypeAndScreen)&&(!_tmpMSBOS.IsNoBloodRequired))
				{
					//Populate the ComponentClasses
					foreach (DataRow drClass in _tmpMSBOS.BloodComponentClasses)
					{
						this._selectedComponentClass = drClass;
						//
						BOL.MsbosComponentClass _tmpMSBOScc = new BOL.MsbosComponentClass(this._selectedComponentClass);
						AddComponentClassNode(_tmpMSBOScc);
					}
				}
			}

			if (this.tvExistingMSBOS.Nodes.Count > 0)
			{
				this.tvExistingMSBOS.SelectedNode = this.tvExistingMSBOS.Nodes[0];
				this.tvExistingMSBOS.SelectedNode = null;
			}
		}

		/// <summary>
		/// AddMSBOSNode
		/// </summary>
		/// <param name="msbos"></param>
		private MsbosTreeNode AddMSBOSNode(BOL.Msbos msbos)
		{
			MsbosTreeNode msbosNode = new MsbosTreeNode();
			msbosNode.Tag = this._selectedMSBOS;
			msbosNode.Text = msbos.SurgeryName;
			if (msbos.IsTypeAndScreen)
			{
				msbosNode.Text = msbosNode.Text + " -- TYPE & SCREEN";
			}
			if (msbos.IsNoBloodRequired)
			{
				msbosNode.Text = msbosNode.Text + " -- NO BLOOD REQUIRED";
			}
			msbosNode.Active = (msbos.RecordStatusCode == Common.RecordStatusCode.Active);
			this.tvExistingMSBOS.Nodes.Add(msbosNode);
			msbosNode.EnsureVisible();
			return msbosNode;
		}

		/// <summary>
		/// UpdateMSBOSNode
		/// </summary>
		/// <param name="msbos"></param>
		private void UpdateMSBOSNode(BOL.Msbos msbos)
		{
			MsbosTreeNode msbosNode;
			if (this.GetSelectedLevel(this.tvExistingMSBOS.SelectedNode) == 1)
			{
				msbosNode = (MsbosTreeNode)this.tvExistingMSBOS.SelectedNode.Parent;
			}
			else
			{
				msbosNode = (MsbosTreeNode)this.tvExistingMSBOS.SelectedNode;
			}
			msbosNode.Tag = this._selectedMSBOS;
			msbosNode.Text = msbos.SurgeryName;
			if (msbos.IsTypeAndScreen)
			{
				msbosNode.Text = msbosNode.Text + " -- TYPE & SCREEN";
			}
			if (msbos.IsNoBloodRequired)
			{
				msbosNode.Text = msbosNode.Text + " -- NO BLOOD REQUIRED";
			}
			msbosNode.Active = (msbos.RecordStatusCode == Common.RecordStatusCode.Active);
			//this.tvExistingMSBOS.SelectedNode = msbosNode;
			msbosNode.EnsureVisible();
		}

		/// <summary>
		/// AddComponentClassNode
		/// </summary>
		/// <param name="msbosCC"></param>
		private void AddComponentClassNode(BOL.MsbosComponentClass msbosCC)
		{
			//
			int parentIndex;
			//
			foreach(TreeNode node in this.tvExistingMSBOS.Nodes)
			{
				DataRow dr = (DataRow)node.Tag;
				if (dr.Equals(_selectedMSBOS))
				{
					parentIndex = node.Index;
					//
					ComponentClassTreeNode componentNode = new ComponentClassTreeNode();
					componentNode.Tag = this._selectedComponentClass;
					componentNode.Text = msbosCC.MaximumSetupUnitQuantity.ToString() + " " + msbosCC.ComponentClassName;
					componentNode.Active = (msbosCC.RecordStatusCode == Common.RecordStatusCode.Active);
					//
					this.tvExistingMSBOS.Nodes[parentIndex].Nodes.Add(componentNode);
					//this.tvExistingMSBOS.SelectedNode = componentNode;
					componentNode.EnsureVisible();		
					//
					break;
				}
			}
		}

		/// <summary>
		/// UpdateComponentClassNode
		/// </summary>
		private void UpdateComponentClassNode()
		{
			foreach(TreeNode parentNode in this.tvExistingMSBOS.Nodes)
			{
				foreach(ComponentClassTreeNode node in parentNode.Nodes)
				{
					DataRow dr = (DataRow)node.Tag;
					if (dr.Equals(this._selectedComponentClass))
					{
						node.Tag = this._selectedComponentClass;
						node.Text = this._msbosComponentClass.MaximumSetupUnitQuantity.ToString()+" " + this._msbosComponentClass.ComponentClassName;
						node.Active = (this._msbosComponentClass.RecordStatusCode == Common.RecordStatusCode.Active);
						//this.tvExistingMSBOS.SelectedNode = node;
						node.EnsureVisible();
						//
						return;
					}
				}
			}
			//
			//Didn't find the node to update.. this is because it was an old inactive record that was "hidden" from the user, so we'll add it instead
			this.AddComponentClassNode(new BOL.MsbosComponentClass(this._selectedComponentClass));
		}

		private void RemoveComponentClassNode(DataRow drComponent)
		{
			foreach(TreeNode parentNode in this.tvExistingMSBOS.Nodes)
			{
				foreach(ComponentClassTreeNode node in parentNode.Nodes)
				{
					DataRow dr = (DataRow)node.Tag;
					if (dr.Equals(drComponent))
					{
						//
						node.Remove();
						//
						//Obliterate unsaved items completely, inactivate previously saved classes
						if (dr.RowState == DataRowState.Added)
						{
							this._msbosComponents.Tables[1].Rows.Remove(dr);
						}
						else
						{
							dr[Common.VbecsTables.MsbosComponentClass.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
						}
						//
						return;
					}
				}
			}
		}

		/// <summary>
		/// SetupFormVariables
		/// </summary>
		private void SetupFormVariables()
		{
			//
			this._msbos = new BOL.Msbos();
			//
			this._msbosComponentClass = new BOL.MsbosComponentClass();
			//
			this._msbosComponents = this._msbos.GetMsbosEntries();
			DataRelation msbosRel = new DataRelation("MSBOSComponents",_msbosComponents.Tables[0].Columns["MsbosGuid"],_msbosComponents.Tables[1].Columns["MsbosGuid"]);
			this._msbosComponents.Relations.Add(msbosRel);

			this.AttachCCEvents();
			this.AttachMSBOSEvents();
		}

		/// <summary>
		/// PopulateOrderableComponents
		/// </summary>
		private void PopulateOrderableComponents()
		{
			this.cmbComponentClass.Items.Clear();

			//Set the form level DataTable
			this._orderableComponentClasses = this._msbos.GetOrderableComponentClasses();

			//Fill the comboBox
			foreach (DataRow _dr in this._orderableComponentClasses.Rows)
			{
				this.cmbComponentClass.Items.Add(_dr[Common.VbecsTables.ComponentClass.ComponentClassName].ToString());
			}
		}

		/// <summary>
		/// GetSelectedLevel
		/// </summary>
		/// <param name="e"></param>
		/// <returns></returns>
		private int GetSelectedLevel(TreeNode e)
		{
			if (this.tvExistingMSBOS.Nodes.Count==0)
			{
				return -1;
			}
			string str = e.FullPath;
			string strcmp = this.tvExistingMSBOS.PathSeparator;
			int pos = 0;
			int level = 0;
			while (str.IndexOf(strcmp,pos) > -1)
			{
				pos = str.IndexOf(strcmp,pos)+1;
				level = level +1;
			}
			return level;
		}


		/// <summary>
		/// Save
		/// </summary>
		private void Save()
		{
			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("MSBOS"));
			if (_saveResult == DialogResult.Yes)
			{
				try
				{
					if (this._msbos.Save(this._msbosComponents,Common.UpdateFunction.UC032DlgMaintainMsbos))
					{
						this.IsDirty = false;
						this.Close();
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("MSBOS data"));
						return;
					}
				}
				catch (RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return;
				}
			}
		}
		#endregion

		#region Control Events


		/// <summary>
		/// tvExistingMSBOS_AfterSelect
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tvExistingMSBOS_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			if (!this._isLoading)
			{
				//string saveText;

				int level = GetSelectedLevel(this.tvExistingMSBOS.SelectedNode);

				this._selectedMSBOS = (level == 1) ? (DataRow)this.tvExistingMSBOS.SelectedNode.Parent.Tag : (DataRow)this.tvExistingMSBOS.SelectedNode.Tag;
				this._msbos = new BOL.Msbos(this._selectedMSBOS);
				this._currentSurgery = this._msbos.SurgeryName;
				this.AttachMSBOSEvents();
				this.SetSurgeryData(false);
				this._msbos.SurgeryName = this._msbos.SurgeryName;
				this.grpRecommendation.Enabled = true;
				this.grpSurgery.Enabled = true;
				//
				string filterStr = MSBOS.MsbosGuid + " = '" + _msbos.MsbosGuid.ToString() + "' AND " + MSBOS.RecordStatusCode + " = 'A'";
				_msbos.BloodComponentClasses = this._msbosComponents.Tables[1].Select(filterStr);
				//this.grpTypeAndScreen.Enabled = (_msbos.BloodComponentClasses.Length==0);
				this.rdoTAS.Enabled = (_msbos.BloodComponentClasses.Length==0);
				this.rdoNoBloodRequired.Enabled = (_msbos.BloodComponentClasses.Length==0);
				this.rdoComponentClass.Checked = (_msbos.BloodComponentClasses.Length>0);
				//
				if (level == 1)		//level 1 = child = Component Classes
				{
					this.CreateComponentClass();
					//saveText = (this._msbosComponentClass.IsNew) ? "&Add" : "&Update";
					//this._msbosComponentClass.SetInitialBrokenRules(this.Name, "ExistingMSBOSComponentClass");
					this.AttachCCEvents();
					//					this._currentComponentClassID = this._msbosComponentClass.ComponentClassId;
					this.SetComponentData(false);
					this.rdoComponentClass.Checked = true;
					this._msbosComponentClass.ComponentClassId = this._msbosComponentClass.ComponentClassId;
					this._msbosComponentClass.MaximumSetupUnitQuantity = this._msbosComponentClass.MaximumSetupUnitQuantity;
					this.cbActive.Enabled = false;
				}
				else			// level 0 = parent = Surgery -- I hope.
				{
					this._selectedComponentClass = null;
					this._msbosComponentClass.Clear();
					//this._msbosComponentClass.SetInitialBrokenRules(this.Name, "NewMSBOSComponentClass");
					this._msbosComponentClass.SetInitialBrokenRules(this.Name,"MsbosComponentClass");
					this._msbosComponentClass.MsbosGuid = this._msbos.MsbosGuid;
					this._msbosComponentClass.MaximumSetupUnitQuantity = 1;
					//
					//saveText = "&Add";
					this.SetComponentData(true);
					this.cbActive.Enabled = true;
				}
				this.SetThisToolTip(this.txtSurgeryName,Common.StrRes.Tooltips.UC032.ExistingSurgeryName());
				this.txtSurgeryName.ReadOnly = true;
				
				//this.grpComponent.Enabled = (!this._msbos.IsTypeAndScreen);
				this.rdoTAS.Checked = this._msbos.IsTypeAndScreen;
				this.rdoNoBloodRequired.Checked = this._msbos.IsNoBloodRequired;

				this._msbos.IsDirty = false;
				this._msbosComponentClass.IsDirty = false;
				this.IsDirty = false;
				//Take care of the control state
				//this.btnEditSurgery.Enabled = true;
				this.btnSave.EnabledButton = false;
				this.SetBtnSaveCaption("&Update");
			}
		}

		/// <summary>
		/// btnNewSurgery_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnNewSurgery_Click(object sender, System.EventArgs e)
		{
			this.tvExistingMSBOS.SelectedNode = null;
			//
			this._msbos.Clear();
			this._msbos.SetInitialBrokenRules(this.Name,"Msbos");
			this.errError.SetVbecsError(txtSurgeryName, ""); // **** 508 Compliance ***
			this._msbos.MsbosGuid = Guid.NewGuid();
			this._msbos.RecordStatusCode = Common.RecordStatusCode.Active;
			this._msbos.IsNew = true;
			this._msbos.IsDirty = false;
			//
			this.SetSurgeryData(true);
			this.grpSurgery.Enabled = true;
			this.grpRecommendation.Enabled = true;
			//
			this.rdoNoBloodRequired.Enabled = true;
			this.rdoTAS.Enabled = true;
			this.rdoComponentClass.Checked = true;
			//
			this.SetBtnSaveCaption("&Add");
			//
			if (this._msbosComponentClass == null)
			{
				this.CreateComponentClass();
			}
			this._msbosComponentClass.Clear();
			this._msbosComponentClass.SetInitialBrokenRules(this.Name,"MsbosComponentClass");
			//this._msbosComponentClass.SetInitialBrokenRules(this.Name);
			this._msbosComponentClass.MsbosGuid = this._msbos.MsbosGuid;
			this._msbosComponentClass.IsNew = true;
			this._msbosComponentClass.IsDirty = false;
			this.SetComponentData(true);
			this._msbosComponentClass.MaximumSetupUnitQuantity = 1;
			//this.grpComponent.Enabled = false;
			//
			this.cbActive.Enabled = true;
			this.cbActive.Checked = true;
			this.SetThisToolTip(this.txtSurgeryName,Common.StrRes.Tooltips.UC032.EnterSurgeryName());
			this.txtSurgeryName.ReadOnly = false;
			this.txtSurgeryName.Focus();
			//
			
		}

		/// <summary>
		/// btnEditSurgery_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnEditSurgery_Click(object sender, System.EventArgs e)
		{
			if (GetSelectedLevel(this.tvExistingMSBOS.SelectedNode) == 0)
			{
				this._selectedMSBOS = (DataRow)this.tvExistingMSBOS.SelectedNode.Tag;
			}
			else
			{
				this._selectedMSBOS = (DataRow)this.tvExistingMSBOS.SelectedNode.Parent.Tag;
			}
			//
			this._msbos = new BOL.Msbos(this._selectedMSBOS);
			this.AttachMSBOSEvents();
			//
			string filterStr = MSBOS.MsbosGuid + " = '" + _msbos.MsbosGuid.ToString() + "'";
			_msbos.BloodComponentClasses = this._msbosComponents.Tables[1].Select(filterStr);
			//this.grpTypeAndScreen.Enabled = (_msbos.BloodComponentClasses.Length==0);
			this.rdoComponentClass.Checked = (_msbos.BloodComponentClasses.Length>0);
			//
			this.SetSurgeryData(false);
			//this.grpSurgery.Enabled = true;
			this.grpComponent.Enabled = (!this._msbos.IsTypeAndScreen);
			this.SetBtnSaveCaption("&Update");
			this.cbActive.Enabled = true;
			this.SetThisToolTip(this.txtSurgeryName,Common.StrRes.Tooltips.UC032.ExistingSurgeryName());
			this.txtSurgeryName.ReadOnly = true;
			this.txtSurgeryName.Focus();
		}

		/// <summary>
		/// cmbComponentClass_SelectedIndexChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbComponentClass_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!_isLoading)
			{
				if (this.cmbComponentClass.SelectedIndex>-1)
				{
					this._msbosComponentClass.ComponentClassId = (int)this._orderableComponentClasses.Rows[this.cmbComponentClass.SelectedIndex][Common.VbecsTables.ComponentClass.ComponentClassId];
					this._msbosComponentClass.ComponentClassName = this.cmbComponentClass.Text;

					string filterStr = MSBOS.MsbosGuid + " = '" + this._msbosComponentClass.MsbosGuid.ToString() + "' AND " + MSBOSCOMPONENTCLASS.ComponentClassId + " = '" + this._msbosComponentClass.ComponentClassId + "'";
					DataRow[] matchingEntries = this._msbosComponents.Tables[1].Select(filterStr);
					//
					if ((matchingEntries == null) ||  (matchingEntries.Length == 0))
					{
						//They may have changed an existing component class entry to a new entry, so create a new Guid for safety...
						this._msbosComponentClass.MsbosComponentClassGuid = Guid.NewGuid();
						try
						{
							this._msbosComponentClass.MaximumSetupUnitQuantity = Convert.ToInt16(this.updUnitsAllowed.Value);
						}
						catch(FormatException)
						{
							this.updUnitsAllowed.Value = this.updUnitsAllowed.Minimum;
						}
						this.SetBtnSaveCaption("&Add");
					}
					else
					{
						this.SetBtnSaveCaption("&Update");
					}
				}
				//
				
			}
		}

		/// <summary>
		/// SetBtnSaveCaption
		/// </summary>
		/// <param name="saveBtnText"></param>
		private void SetBtnSaveCaption(string saveBtnText)
		{
			if (this.btnSave.Text != saveBtnText)
			{
				this.btnSave.Text = saveBtnText;
			}
		}

		/// <summary>
		/// updUnitsAllowed_ValueChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void updUnitsAllowed_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!_isLoading)
				{
					try
					{
						this._msbosComponentClass.MaximumSetupUnitQuantity = (short)this.updUnitsAllowed.Value;
					}
					catch(FormatException)
					{
						this._msbosComponentClass.MaximumSetupUnitQuantity = short.MinValue;
					}
				}
				this.errError.SetVbecsError(this.updUnitsAllowed, String.Empty); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.updUnitsAllowed, err.Message); // **** 508 Compliance ***
			}
		}

		private void updUnitsAllowed_Leave(object sender, EventArgs e)
		{
			try
			{
				if (!_isLoading)
				{
					try
					{
						this._msbosComponentClass.MaximumSetupUnitQuantity = (short)this.updUnitsAllowed.Value;
					}
					catch(FormatException err)
					{
						this._msbosComponentClass.MaximumSetupUnitQuantity = short.MinValue;
						this.errError.SetVbecsError(this.updUnitsAllowed, err.Message); // **** 508 Compliance ***
						return;
					}
				}
				this.errError.SetVbecsError(this.updUnitsAllowed, String.Empty); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.updUnitsAllowed, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// cbTypeAndScreen_CheckedChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbTypeAndScreen_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				//if (this.cbTypeAndScreen.Checked)
				if (this.rdoTAS.Checked)
				{
					//string filterStr = "MsbosGuid = '" + this._msbos.MSBOSGUID.ToString() + "'";
					string filterStr = MSBOS.MsbosGuid + " = '" + _msbos.MsbosGuid.ToString() + "' AND " + MSBOS.RecordStatusCode + " = 'A'";
					this._msbos.BloodComponentClasses = this._msbosComponents.Tables[1].Select(filterStr);
				
					if (this._msbos.BloodComponentClasses.Length>0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotChangeMSBOSToTypeAndScreen(this._msbos.SurgeryName));
						this.rdoTAS.Checked = false;
						return;
					}
				}
			}
			//
			//this.grpComponent.Enabled = (this.rdoComponentClass.Checked);
			//
			try
			{
				if (!this._isLoading)
				{
					if ((!this._msbos.IsNew)&&(this.rdoTAS.Checked))
					{
						this.btnSave.Text = "&Update";
					}

					//this._msbos.IsTypeAndScreen = this.cbTypeAndScreen.Checked;
					this._msbos.IsTypeAndScreen = this.rdoTAS.Checked;
					if (!this.IsDuplicateSurgery())
					{
						this.errError.SetVbecsError(this.txtSurgeryName, String.Empty); // **** 508 Compliance ***
					}
				}
				this.errError.SetVbecsError(this.rdoTAS, String.Empty); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.rdoTAS, err.Message); // **** 508 Compliance ***
			}		
		}

		/// <summary>
		/// cbActive_CheckedChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbActive_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.cbActive.Checked)
				{
					this._msbos.RecordStatusCode = Common.RecordStatusCode.Active;
				}
				else
				{
					this._msbos.RecordStatusCode = Common.RecordStatusCode.Inactive;
				}
			}
		}

		/// <summary>
		/// DlgMaintainMsbos_Load
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgMaintainMsbos_Load(object sender, System.EventArgs e)
		{
			this._msbosComponents.AcceptChanges();
			this._msbosComponents.Tables[0].RowChanged += new System.Data.DataRowChangeEventHandler(MSBOSDataSetChanged);
			this._msbosComponents.Tables[1].RowChanged += new System.Data.DataRowChangeEventHandler(MSBOSDataSetChanged);
			//
			//initial dirty value is false.
			this.IsDirty=false;
		}

		/// <summary>
		/// btnOK_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Save();
		}

		/// <summary>
		/// btnSave_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			if (this.grpSurgery.Enabled)
			{
				if (this._msbos.IsDirty)
				{
					if (this._msbos.IsNew)
					{
						this._selectedMSBOS = this._msbosComponents.Tables[0].NewRow();
						this._selectedMSBOS[MSBOS.SurgeryName] = this._msbos.SurgeryName;
						this._selectedMSBOS[MSBOS.MsbosGuid] = this._msbos.MsbosGuid;
						this._selectedMSBOS[MSBOS.TypeAndScreenIndicator] = this._msbos.IsTypeAndScreen;
						this._selectedMSBOS[MSBOS.NoBloodRequiredIndicator] = this._msbos.IsNoBloodRequired;
						this._selectedMSBOS[MSBOS.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
						this._selectedMSBOS[MSBOS.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(this._msbos.RecordStatusCode);
						this._selectedMSBOS[MSBOS.LastUpdateUser] = ThisUser.UserNTLoginID;
						//
						MsbosTreeNode msbosNode = AddMSBOSNode(this._msbos);
						//this.tvExistingMSBOS.SelectedNode = msbosNode;
						//
						this._msbosComponents.Tables[0].Rows.Add(this._selectedMSBOS);
					}
					else
					{
						this._selectedMSBOS[MSBOS.SurgeryName] = this._msbos.SurgeryName;
						this._selectedMSBOS[MSBOS.TypeAndScreenIndicator] = this._msbos.IsTypeAndScreen;
						this._selectedMSBOS[MSBOS.NoBloodRequiredIndicator] = this._msbos.IsNoBloodRequired;
						this._selectedMSBOS[MSBOS.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(this._msbos.RecordStatusCode);
						this._selectedMSBOS[MSBOS.LastUpdateUser] = ThisUser.UserNTLoginID;
						//
						UpdateMSBOSNode(this._msbos);
					}
					//
					if (this._msbos.IsTypeAndScreen || this._msbos.IsNoBloodRequired)
					{
						string filterStr = MSBOS.MsbosGuid + " = '" + this._msbos.MsbosGuid.ToString() + "'";
						DataRow[] matchingEntries = this._msbosComponents.Tables[1].Select(filterStr);
						if ((matchingEntries != null) && (matchingEntries.Length>0))
						{
							foreach(DataRow dr in matchingEntries)
							{
								RemoveComponentClassNode(dr);
							}
						}
					}
				}
				this.SetSurgeryData(false);
				//this.grpSurgery.Enabled = false;
			}
			if (this.grpComponent.Enabled)
			{
				if (this._msbosComponentClass.IsDirty)
				{
					if (this._msbosComponentClass.ComponentClassId>-1)
					{
						//Only one entry per component class type..Check if exists in dataset already, if so reselect tree view node and datarow..
						string filterStr = MSBOS.MsbosGuid + " = '" + this._msbosComponentClass.MsbosGuid.ToString() + "' AND " + MSBOSCOMPONENTCLASS.ComponentClassId + " = '" + this._msbosComponentClass.ComponentClassId + "'";
						DataRow[] matchingEntries = this._msbosComponents.Tables[1].Select(filterStr);
						//
						if (matchingEntries.Length >0)
						{
							_selectedComponentClass = matchingEntries[0]; 
							this._selectedComponentClass[MSBOSCOMPONENTCLASS.MaximumSetupUnitQuantity] = this._msbosComponentClass.MaximumSetupUnitQuantity;
							this._selectedComponentClass[MSBOSCOMPONENTCLASS.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(this._msbosComponentClass.RecordStatusCode);
							this._selectedComponentClass[Common.VbecsTables.ComponentClass.LastUpdateUser] = ThisUser.UserNTLoginID;
							//
							UpdateComponentClassNode();
						}
						else
						{
							this._selectedComponentClass = this._msbosComponents.Tables[1].NewRow();
							this._selectedComponentClass[MSBOSCOMPONENTCLASS.MsbosComponentClassGuid] = this._msbosComponentClass.MsbosComponentClassGuid;
							this._selectedComponentClass[MSBOS.MsbosGuid] = this._msbosComponentClass.MsbosGuid;
							this._selectedComponentClass[MSBOSCOMPONENTCLASS.ComponentClassId] = this._msbosComponentClass.ComponentClassId;
							this._selectedComponentClass[MSBOSCOMPONENTCLASS.MaximumSetupUnitQuantity] = this._msbosComponentClass.MaximumSetupUnitQuantity;
							this._selectedComponentClass[MSBOSCOMPONENTCLASS.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(this._msbosComponentClass.RecordStatusCode);
							this._selectedComponentClass[MSBOS.LastUpdateUser] = ThisUser.UserNTLoginID;
							this._selectedComponentClass[Common.VbecsTables.ComponentClass.ComponentClassName] = this._msbosComponentClass.ComponentClassName;
							//
							AddComponentClassNode(this._msbosComponentClass);
							//
							this._msbosComponents.Tables[1].Rows.Add(this._selectedComponentClass);
						}
						this._selectedComponentClass = null;
						this._msbosComponentClass.Clear();
						this._msbosComponentClass.SetInitialBrokenRules(this.Name,"MsbosComponentClass");

						this.SetComponentData(true);
						this._msbosComponentClass.MsbosGuid = this._msbos.MsbosGuid;
						this.grpComponent.Enabled = true;
					}
				}
				//
				//this.rdoTAS.Enabled = false;
				//this.rdoNoBloodRequired.Enabled = false;
				string filter = MSBOS.MsbosGuid + " = '" + _msbos.MsbosGuid.ToString() + "' AND " + MSBOS.RecordStatusCode + " = 'A'";
				_msbos.BloodComponentClasses = this._msbosComponents.Tables[1].Select(filter);
				this.rdoTAS.Enabled = (_msbos.BloodComponentClasses.Length==0);
				this.rdoNoBloodRequired.Enabled = (_msbos.BloodComponentClasses.Length==0);
				this.rdoComponentClass.Checked = (_msbos.BloodComponentClasses.Length>0);
			}
			this.SelectMSBOSParentNode(this._msbos.MsbosGuid);
			this.btnSave.EnabledButton = false;
			this.btnSave.SetToolTip(String.Empty);
			this.SetThisToolTip(this.txtSurgeryName,Common.StrRes.Tooltips.UC032.ExistingSurgeryName());
			this.txtSurgeryName.ReadOnly = true;
			this.cbActive.Enabled = true;
			this.tvExistingMSBOS.Focus();
		}

		private void SelectMSBOSParentNode(Guid msbosGUID)
		{
			foreach(TreeNode tvNode in this.tvExistingMSBOS.Nodes)
			{
				if (this.GetSelectedLevel(tvNode)==0)
				{
					DataRow dr = (DataRow)tvNode.Tag;
					if (msbosGUID == (Guid)dr[Common.VbecsTables.Msbos.MsbosGuid])
					{
						this.tvExistingMSBOS.SelectedNode = tvNode;
						break;
					}
				}
			}
		}

		#endregion

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgMaintainMsbos_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			textToSpeak = string.Concat(this.btnOK.GetToolTip(), this.btnSave.GetToolTip());
			this.SpeakMessage( textToSpeak );
		}


		private void cbShowInactive_CheckedChanged(object sender, System.EventArgs e)
		{
			this.LoadMSBOSTreeView();
			this.SetSurgeryData(true);
			this.SetComponentData(true);
			this.grpSurgery.Enabled = false;
			this.grpRecommendation.Enabled = false;
		}

		private void cbActiveComponent_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.cbActiveComponent.Checked)
				{
					this._msbosComponentClass.RecordStatusCode = Common.RecordStatusCode.Active;
				}
				else
				{
					this._msbosComponentClass.RecordStatusCode = Common.RecordStatusCode.Inactive;
				}
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void rdoComponentClass_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpComponent.Enabled = this.rdoComponentClass.Checked;
			//
			if (!this._isLoading)
			{
				if ((!this._msbos.IsNew)&&(this.rdoComponentClass.Checked))
				{
					this.cmbComponentClass_SelectedIndexChanged(sender,e);
				}
			}
		}

		private void rdoNoBloodRequired_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.rdoNoBloodRequired.Checked)
				{
					//string filterStr = "MsbosGuid = '" + this._msbos.MSBOSGUID.ToString() + "'";
					string filterStr = MSBOS.MsbosGuid + " = '" + _msbos.MsbosGuid.ToString() + "' AND " + MSBOS.RecordStatusCode + " = 'A'";
					this._msbos.BloodComponentClasses = this._msbosComponents.Tables[1].Select(filterStr);
				
					if (this._msbos.BloodComponentClasses.Length>0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotChangeMSBOSToTypeAndScreen(this._msbos.SurgeryName));
						this.rdoNoBloodRequired.Checked = false;
						return;
					}
				}
			}
			//
			//this.grpComponent.Enabled = (this.rdoComponentClass.Checked);
			//
			try
			{
				if (!this._isLoading)
				{
					if ((!this._msbos.IsNew)&&(this.rdoNoBloodRequired.Checked))
					{
						this.btnSave.Text = "&Update";
					}
					this._msbos.IsNoBloodRequired = this.rdoNoBloodRequired.Checked;
					if (!this.IsDuplicateSurgery())
					{
						this.errError.SetVbecsError(this.txtSurgeryName, String.Empty); // **** 508 Compliance ***
					}
				}
				this.errError.SetVbecsError(this.rdoNoBloodRequired, String.Empty); // **** 508 Compliance ***
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.rdoNoBloodRequired, err.Message); // **** 508 Compliance ***
			}
		}


		private void txtSurgeryName_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading && !txtSurgeryName.ReadOnly)
				{
					this._msbos.SurgeryName = this.txtSurgeryName.Text;
					this.errError.SetVbecsError(this.txtSurgeryName, String.Empty); // **** 508 Compliance ***
					//
					if (this.txtSurgeryName.Text.Length > 0)
					{
						if (!this.IsDuplicateSurgery())
						{
							this.errError.SetVbecsError(this.txtSurgeryName, String.Empty); // **** 508 Compliance ***
						}
					}
					//
					OnObjectsValidStateChanges(null, System.EventArgs.Empty);
				}
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtSurgeryName, err.Message); // **** 508 Compliance ***
			}
		}

		private void btnSave_MouseHover(object sender, System.EventArgs e)
		{
			string tooltip = "";
			//
			if (!_isLoading)
			{
				if (this._msbos != null)
				{
					//
					if (!this._msbos.IsValid)
					{
						tooltip+=this._msbos.GetBrokenRulesMessage(this.Name)+"\n";
					}
					//
					//We have to do this check here, since IsDuplicateSurgery can't be performed in BOL
					if (this.errError.GetError(this.txtSurgeryName).Length != 0)
					{
						tooltip+=this.errError.GetError(this.txtSurgeryName)+"\n";
					}
					//
					string filterStr = MSBOS.MsbosGuid + " = '" + _msbos.MsbosGuid.ToString() + "'";
					int activeClasses = this._msbosComponents.Tables[1].Select(filterStr).Length;
					//
					if ((activeClasses==0) || ((this.tvExistingMSBOS.SelectedNode!=null) && (this.GetSelectedLevel(this.tvExistingMSBOS.SelectedNode)==1)))
					{
						if ((!this._msbos.IsTypeAndScreen) && (!this.rdoNoBloodRequired.Checked))
						{
							if (!this._msbosComponentClass.IsValid)
							{
								tooltip+=this._msbosComponentClass.GetBrokenRulesMessage(this.Name)+"\n";
							}
						}
					}
				}
			}
			//
			if (tooltip.Length==0)
			{
				if (this.btnSave.EnabledButton)
				{
					tooltip=Common.StrRes.Tooltips.Common.AddOrUpdate("MSBOS").ResString;
				}
				else
				{
					tooltip=Common.StrRes.Tooltips.Common.NoChangesToAddOrUpdate().ResString;
				}
			}
			//
			btnSave.SetToolTip(tooltip);
		}

		private void DlgMaintainMsbos_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			//This is a crappy little hack to deselect all nodes the first time the
			//screen loads. Setting SelectedNode to null only seems to work when the
			//treeview is painted. Gah!
			//Minimizing and maximizing will cause the first node to be selected. Strange behavior indeed.
			if (_firsttimePaint)
			{
				this.cbShowInactive_CheckedChanged(sender,e);
				_firsttimePaint = false;
			}
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnOK.EnabledButton)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			}
		}


	}

#region MsbosTreeNode Class
	/// <summary>
	/// MsbosTreeNode
	/// </summary>
	public class MsbosTreeNode : TreeNode
	{
		bool _active;

		/// <summary>
		/// MsbosTreeNode
		/// </summary>
		public MsbosTreeNode() : base()
		{
			this.ImageIndex = 0;
			this.SelectedImageIndex = 0;
		}

		#region Properties

		/// <summary>
		/// Active
		/// </summary>
		public bool Active
		{
			get 
			{ 
				return _active;
			}
			set
			{
				this._active = value;
				if (this._active)
				{
					this.ForeColor = Color.FromKnownColor(KnownColor.ControlText);
				}
				else
				{
					this.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
				}
			}
		}
		#endregion

	}


#endregion


#region ComponentClassTreeNode Class

	/// <summary>
	/// ComponentClassTreeNode
	/// </summary>
	public class ComponentClassTreeNode : TreeNode
	{
		bool _active;

		/// <summary>
		/// ComponentClassTreeNode
		/// </summary>
		public ComponentClassTreeNode() : base()
		{
			this.ImageIndex = 1;
			this.SelectedImageIndex = 1;
		}

		#region Properties

		/// <summary>
		/// Active
		/// </summary>
		public bool Active
		{
			get 
			{ 
				return _active;
			}
			set
			{
				this._active = value;
				if (this._active)
				{
					this.ForeColor = Color.FromKnownColor(KnownColor.ControlText);
				}
				else
				{
					this.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
				}
			}
		}
		#endregion

	}


#endregion

}
